from PyQt5.QtWidgets import QAction


def classFactory(iface):
    return DependentPlugin1(iface)


class DependentPlugin1:
    def __init__(self, iface):
        self.iface = iface

    def initGui(self):
        self.action = QAction("Go!", self.iface.mainWindow())
        self.action.triggered.connect(self.run)
        self.iface.addToolBarIcon(self.action)

    def unload(self):
        self.iface.removeToolBarIcon(self.action)
        del self.action

    def run(self):
        pass
