"""QGIS Unit tests for QGIS network analysis.

.. note:: This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
"""

import unittest

from qgis.analysis import (
    QgsVectorLayerDirector,
    QgsNetworkDistanceStrategy,
    QgsGraphBuilder,
    QgsGraphAnalyzer,
)
from qgis.core import QgsVectorLayer, QgsPointXY
from qgis.testing import start_app, QgisTestCase

from utilities import unitTestDataPath

start_app()
TEST_DATA_DIR = unitTestDataPath()


class TestQgsNetworkAnalysis(QgisTestCase):

    def test_analysis(self):
        network_layer = QgsVectorLayer(
            self.get_test_data_path("roads.gml").as_posix(), "lines"
        )
        director = QgsVectorLayerDirector(
            network_layer, -1, "", "", "", QgsVectorLayerDirector.DirectionBoth
        )
        strategy = QgsNetworkDistanceStrategy()
        director.addStrategy(strategy)
        builder = QgsGraphBuilder(network_layer.crs())

        start_point = QgsPointXY(1179661.925139, 5419188.074362)
        tied_point = director.makeGraph(builder, [start_point])
        start_point = tied_point[0]

        graph = builder.graph()

        id_start = graph.findVertex(start_point)

        tree, costs = QgsGraphAnalyzer.dijkstra(graph, id_start, 0)
        self.assertEqual(
            tree,
            [
                82,
                0,
                386,
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                116,
                30,
                32,
                468,
                37,
                39,
                41,
                43,
                45,
                109,
                46,
                51,
                879,
                52,
                54,
                56,
                58,
                60,
                62,
                64,
                66,
                68,
                73,
                75,
                77,
                79,
                81,
                92,
                86,
                910,
                88,
                90,
                94,
                96,
                98,
                103,
                105,
                107,
                111,
                113,
                908,
                114,
                881,
                132,
                123,
                125,
                126,
                128,
                130,
                134,
                136,
                138,
                143,
                145,
                148,
                150,
                152,
                154,
                156,
                158,
                161,
                277,
                899,
                162,
                164,
                169,
                903,
                901,
                170,
                172,
                174,
                179,
                192,
                181,
                182,
                185,
                187,
                189,
                191,
                897,
                194,
                196,
                198,
                200,
                202,
                204,
                206,
                209,
                211,
                225,
                215,
                217,
                219,
                221,
                223,
                227,
                229,
                231,
                235,
                319,
                232,
                237,
                239,
                241,
                243,
                245,
                247,
                249,
                251,
                253,
                255,
                257,
                259,
                261,
                263,
                265,
                267,
                269,
                271,
                273,
                275,
                279,
                281,
                283,
                285,
                287,
                289,
                291,
                293,
                295,
                297,
                348,
                298,
                300,
                305,
                307,
                309,
                311,
                313,
                315,
                317,
                321,
                322,
                324,
                326,
                328,
                330,
                335,
                337,
                339,
                341,
                502,
                342,
                346,
                -1,
                350,
                352,
                354,
                356,
                358,
                360,
                362,
                364,
                366,
                368,
                370,
                372,
                374,
                376,
                378,
                380,
                382,
                384,
                389,
                390,
                392,
                394,
                396,
                398,
                400,
                402,
                404,
                406,
                408,
                410,
                412,
                414,
                416,
                418,
                420,
                422,
                424,
                426,
                428,
                430,
                674,
                434,
                436,
                768,
                440,
                442,
                444,
                446,
                842,
                450,
                452,
                454,
                456,
                458,
                914,
                462,
                464,
                466,
                471,
                771,
                475,
                477,
                479,
                481,
                483,
                485,
                487,
                489,
                529,
                531,
                492,
                495,
                497,
                499,
                535,
                504,
                506,
                508,
                670,
                663,
                515,
                517,
                519,
                521,
                523,
                525,
                527,
                533,
                540,
                536,
                542,
                672,
                544,
                546,
                548,
                550,
                552,
                554,
                556,
                558,
                560,
                562,
                564,
                566,
                568,
                570,
                572,
                574,
                576,
                578,
                580,
                582,
                584,
                586,
                588,
                590,
                592,
                594,
                596,
                598,
                600,
                602,
                604,
                606,
                608,
                610,
                612,
                614,
                616,
                618,
                620,
                622,
                627,
                631,
                633,
                634,
                636,
                640,
                642,
                645,
                651,
                652,
                746,
                657,
                748,
                665,
                666,
                668,
                676,
                678,
                680,
                682,
                684,
                686,
                688,
                690,
                692,
                694,
                696,
                698,
                703,
                705,
                707,
                710,
                712,
                714,
                716,
                718,
                720,
                728,
                735,
                724,
                726,
                733,
                737,
                739,
                741,
                772,
                742,
                744,
                752,
                754,
                912,
                759,
                761,
                763,
                765,
                767,
                774,
                782,
                776,
                781,
                784,
                786,
                788,
                799,
                794,
                796,
                801,
                803,
                805,
                806,
                808,
                810,
                812,
                814,
                816,
                818,
                821,
                838,
                822,
                824,
                831,
                833,
                837,
                840,
                846,
                892,
                850,
                852,
                854,
                856,
                858,
                860,
                865,
                886,
                920,
                869,
                871,
                873,
                875,
                877,
                907,
                884,
                888,
                890,
                895,
                905,
                916,
                918,
                922,
                924,
            ],
        )
        self.assertEqual(
            [round(c, 0) for c in costs],
            [
                4153.0,
                4220.0,
                2889.0,
                2936.0,
                3019.0,
                3198.0,
                3382.0,
                3474.0,
                3526.0,
                3568.0,
                3653.0,
                3847.0,
                4366.0,
                4475.0,
                4525.0,
                4613.0,
                4691.0,
                4321.0,
                4458.0,
                4682.0,
                4103.0,
                4119.0,
                4105.0,
                4073.0,
                3980.0,
                3954.0,
                3888.0,
                3944.0,
                3963.0,
                3898.0,
                4059.0,
                4171.0,
                4277.0,
                4469.0,
                4535.0,
                4605.0,
                4672.0,
                4723.0,
                4771.0,
                4792.0,
                4717.0,
                4656.0,
                4597.0,
                4562.0,
                4169.0,
                4245.0,
                3686.0,
                3778.0,
                3922.0,
                4556.0,
                4668.0,
                4775.0,
                3747.0,
                3723.0,
                3699.0,
                3697.0,
                3678.0,
                3573.0,
                4281.0,
                3671.0,
                4500.0,
                4512.0,
                4254.0,
                4016.0,
                4088.0,
                4246.0,
                4667.0,
                4736.0,
                4912.0,
                4124.0,
                4059.0,
                4387.0,
                4435.0,
                4564.0,
                4579.0,
                4604.0,
                4847.0,
                1438.0,
                1181.0,
                4035.0,
                4063.0,
                4154.0,
                4023.0,
                3859.0,
                3924.0,
                4027.0,
                4141.0,
                4162.0,
                4266.0,
                4182.0,
                4824.0,
                4778.0,
                5055.0,
                4987.0,
                4901.0,
                4594.0,
                4094.0,
                4819.0,
                4840.0,
                4923.0,
                5016.0,
                5146.0,
                5191.0,
                5224.0,
                5137.0,
                5110.0,
                5095.0,
                5036.0,
                5023.0,
                5009.0,
                4962.0,
                4901.0,
                5079.0,
                4965.0,
                2957.0,
                2848.0,
                5082.0,
                5109.0,
                2715.0,
                2686.0,
                2669.0,
                2616.0,
                2576.0,
                2532.0,
                2492.0,
                2442.0,
                2381.0,
                2195.0,
                2123.0,
                2086.0,
                2041.0,
                1987.0,
                1939.0,
                1884.0,
                1827.0,
                1767.0,
                1704.0,
                1636.0,
                1034.0,
                1001.0,
                958.0,
                936.0,
                866.0,
                802.0,
                741.0,
                648.0,
                574.0,
                500.0,
                384.0,
                5233.0,
                5245.0,
                5289.0,
                5250.0,
                5243.0,
                5225.0,
                5162.0,
                5144.0,
                5126.0,
                5070.0,
                2751.0,
                2832.0,
                3203.0,
                3257.0,
                3483.0,
                3421.0,
                3368.0,
                3298.0,
                3194.0,
                3156.0,
                5220.0,
                5288.0,
                0.0,
                479.0,
                557.0,
                657.0,
                805.0,
                863.0,
                1099.0,
                1612.0,
                1672.0,
                1722.0,
                1773.0,
                1839.0,
                1996.0,
                2213.0,
                2392.0,
                2398.0,
                2713.0,
                2801.0,
                2833.0,
                927.0,
                4543.0,
                4565.0,
                4598.0,
                4661.0,
                1285.0,
                1343.0,
                1620.0,
                1709.0,
                1809.0,
                2193.0,
                2338.0,
                2368.0,
                2396.0,
                2488.0,
                2542.0,
                2593.0,
                2805.0,
                2901.0,
                2993.0,
                3050.0,
                3165.0,
                3131.0,
                3199.0,
                3333.0,
                3350.0,
                3503.0,
                3592.0,
                3658.0,
                3675.0,
                3641.0,
                3702.0,
                3766.0,
                3818.0,
                3851.0,
                3915.0,
                3912.0,
                3949.0,
                4035.0,
                4066.0,
                1387.0,
                2308.0,
                2230.0,
                1905.0,
                1343.0,
                1057.0,
                3408.0,
                3110.0,
                3055.0,
                2999.0,
                2902.0,
                3583.0,
                2548.0,
                3409.0,
                3370.0,
                3320.0,
                3229.0,
                2323.0,
                2400.0,
                2703.0,
                3571.0,
                3421.0,
                3390.0,
                3305.0,
                3260.0,
                3193.0,
                3124.0,
                3082.0,
                2915.0,
                3318.0,
                2450.0,
                2498.0,
                2586.0,
                3657.0,
                3756.0,
                3884.0,
                3903.0,
                4067.0,
                4128.0,
                4158.0,
                4238.0,
                4274.0,
                4292.0,
                4310.0,
                4330.0,
                4357.0,
                4378.0,
                4385.0,
                4391.0,
                4400.0,
                4414.0,
                4426.0,
                4435.0,
                4446.0,
                4463.0,
                4536.0,
                4613.0,
                4649.0,
                4668.0,
                4690.0,
                4714.0,
                4753.0,
                4842.0,
                4978.0,
                5104.0,
                5162.0,
                5177.0,
                5190.0,
                5202.0,
                5216.0,
                5229.0,
                5244.0,
                2765.0,
                2906.0,
                3037.0,
                2830.0,
                2814.0,
                4332.0,
                3342.0,
                3492.0,
                2980.0,
                3206.0,
                2925.0,
                4007.0,
                3017.0,
                2971.0,
                2991.0,
                3250.0,
                3404.0,
                3543.0,
                4740.0,
                4783.0,
                4852.0,
                4898.0,
                4953.0,
                5029.0,
                5073.0,
                5144.0,
                5215.0,
                5272.0,
                5328.0,
                5392.0,
                5418.0,
                5319.0,
                5283.0,
                3849.0,
                3897.0,
                3919.0,
                3924.0,
                4062.0,
                4293.0,
                4286.0,
                3843.0,
                3876.0,
                4000.0,
                3874.0,
                3797.0,
                3666.0,
                2614.0,
                2523.0,
                2842.0,
                2872.0,
                4030.0,
                3760.0,
                3751.0,
                3695.0,
                3488.0,
                3469.0,
                3302.0,
                3130.0,
                2801.0,
                2252.0,
                3482.0,
                3709.0,
                3938.0,
                4016.0,
                4110.0,
                4069.0,
                4142.0,
                4334.0,
                4030.0,
                4014.0,
                3980.0,
                2480.0,
                2548.0,
                2581.0,
                2631.0,
                2652.0,
                3895.0,
                3988.0,
                4411.0,
                4200.0,
                4239.0,
                3860.0,
                4029.0,
                4014.0,
                3964.0,
                4281.0,
                4152.0,
                4198.0,
                4377.0,
                4479.0,
                4726.0,
                4423.0,
                2892.0,
                4010.0,
                4135.0,
                4082.0,
                4531.0,
                4562.0,
                4512.0,
                4494.0,
                4477.0,
                4471.0,
                3563.0,
                4050.0,
                4097.0,
                4134.0,
                4104.0,
                3725.0,
                4417.0,
                4500.0,
                4611.0,
                4655.0,
            ],
        )


if __name__ == "__main__":
    unittest.main()
